<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\CryptoAsset;
use Illuminate\Http\Request;

class CryptoController extends Controller
{
    public function show(User $user)
    {
        $cryptoAssets = $user->cryptoAssets ?? $user->createCryptoAssets();
        $supportedCryptos = \App\Models\CryptoAsset::getSupportedCryptos();
        return view('admin.users.crypto', compact('user', 'cryptoAssets', 'supportedCryptos'));
    }

    public function update(Request $request, User $user)
    {
        // If we're just updating status, validate differently
        if ($request->has('status_update')) {
            $request->validate([
                'crypto' => 'required|string',
                $request->crypto . '_status' => 'boolean'
            ]);

            $cryptoAssets = $user->cryptoAssets ?? $user->createCryptoAssets();
            $statusField = $request->crypto . '_status';
            $cryptoAssets->$statusField = $request->boolean($statusField);
            $cryptoAssets->save();

            return back()->with('status', 'Status updated successfully');
        }

        // Original balance update logic
        $request->validate([
            'crypto' => 'required|string',
            'amount' => 'nullable|numeric|min:0',
            'action' => 'nullable|in:add,subtract',
        ]);

        $cryptoAssets = $user->cryptoAssets ?? $user->createCryptoAssets();
        $balanceField = $request->crypto . '_balance';
        
        if ($request->filled('amount') && $request->filled('action')) {
            $currentBalance = $cryptoAssets->$balanceField ?? 0;
            $amount = $request->amount;

            if ($request->action === 'add') {
                $cryptoAssets->$balanceField = $currentBalance + $amount;
            } else {
                if ($currentBalance >= $amount) {
                    $cryptoAssets->$balanceField = $currentBalance - $amount;
                } else {
                    return back()->with('error', 'Insufficient balance for subtraction');
                }
            }
        }

        $cryptoAssets->save();
        return back()->with('status', 'Crypto asset updated successfully');
    }
}