<x-admin-layout>
    <div class="container px-6 mx-auto">
        <div class="flex justify-between items-center my-6">
            <h2 class="text-2xl font-semibold text-gray-700">Users Management</h2>
            <a href="{{ route('admin.users.create') }}" 
               class="px-4 py-2 text-sm font-medium text-white bg-purple-600 rounded-lg hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2">
                <i class="ri-user-add-line mr-2"></i>Create User
            </a>
        </div>

        {{-- Flash Messages --}}
        <x-session-status class="mb-4" :status="session('status')" :errors="$errors" />

        {{-- Filters and Search --}}
        <div class="mb-6 p-4 bg-white rounded-lg shadow-md">
            <form action="{{ route('admin.users') }}" method="GET" class="grid gap-4 md:grid-cols-4">
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-700">KYC Status</label>
                    <select name="kyc_status" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500">
                        <option value="">All Status</option>
                        <option value="approved">Approved</option>
                        <option value="pending">Pending</option>
                        <option value="rejected">Rejected</option>
                        <option value="not_submitted">Not Submitted</option>
                    </select>
                </div>
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-700">Search</label>
                    <input type="text" name="search" placeholder="Search by name, email or ID..." 
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500">
                </div>
                <div class="md:col-span-2 flex items-end">
                    <button type="submit" class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700">
                        <i class="ri-filter-3-line mr-2"></i>Apply Filters
                    </button>
                </div>
            </form>
        </div>

        {{-- Users Table --}}
        <div class="bg-white rounded-lg shadow-md overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full whitespace-no-wrap">
                    <thead>
                        <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase bg-gray-50 border-b">
                            <th class="px-4 py-3">User</th>
                            <th class="px-4 py-3">KYC Status</th>
                            <th class="px-4 py-3">Crypto Balance</th>
                            <th class="px-4 py-3">Register Date</th>
                            <th class="px-4 py-3">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y">
                        @forelse($users as $user)
                            <tr class="text-gray-700">
                                <td class="px-4 py-3">
                                    <div class="flex items-center">
                                        <div class="flex-shrink-0 h-10 w-10">
                                            <div class="h-10 w-10 rounded-full bg-purple-100 flex items-center justify-center">
                                                <span class="text-lg font-medium text-purple-600">
                                                    {{ strtoupper(substr($user->name, 0, 1)) }}
                                                </span>
                                            </div>
                                        </div>
                                        <div class="ml-4">
                                            <div class="text-sm font-medium">{{ $user->name }}</div>
                                            <div class="text-sm text-gray-500">{{ $user->email }}</div>
                                            <div class="text-xs text-gray-400">ID: {{ $user->uuid }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-4 py-3">
                                    <span class="px-2 py-1 text-xs rounded-full 
                                        @if($user->kyc_status === 'approved') bg-green-100 text-green-800
                                        @elseif($user->kyc_status === 'pending') bg-yellow-100 text-yellow-800
                                        @elseif($user->kyc_status === 'rejected') bg-red-100 text-red-800
                                        @else bg-gray-100 text-gray-800 @endif">
                                        {{ ucfirst($user->kyc_status) }}
                                    </span>
                                </td>
                                <td class="px-4 py-3">
                                    <div class="text-sm">${{ number_format($user->getTotalBalanceUSD(), 2) }}</div>
                                    <div class="text-xs text-gray-500">
                                        {{ $user->hasCryptoAssets() ? count($user->cryptoAssets->getActiveCryptos()) : 0 }} Active Assets
                                    </div>
                                </td>
                                <td class="px-4 py-3 text-sm">
                                    {{ $user->created_at->format('M d, Y') }}
                                </td>
                                <td class="px-4 py-3">
                                    <div class="flex items-center space-x-2">
                                        {{-- View Crypto Assets --}}
                                        <button type="button" title="View Crypto Assets" 
                                                onclick="window.location.href='{{ route('admin.users.crypto', $user) }}'"
                                                class="p-1 text-blue-600 hover:text-blue-900 rounded-full hover:bg-blue-100">
                                            <i class="ri-coin-line text-lg"></i>
                                        </button>
                                         {{-- Edit Crypto Address --}}
        <button type="button" 
                title="Edit Crypto Address"
                onclick="openEditAddressModal('{{ $user->id }}')"
                class="p-1 text-indigo-600 hover:text-indigo-900 rounded-full hover:bg-indigo-100">
            <i class="ri-edit-circle-line text-lg"></i>
        </button>
        {{-- Edit Network Fee --}}
        <button type="button" 
        title="Edit Crypto Fees"
        onclick="openFeeModal('{{ $user->id }}')"
        class="p-1 text-green-600 hover:text-green-900 rounded-full hover:bg-green-100">
    <i class="ri-money-dollar-circle-line text-lg"></i>
</button>
{{-- Edit Swap Fee --}}
<button type="button" 
        title="Edit Swap Fees"
        onclick="openSwapFeeModal('{{ $user->id }}')"
        class="p-1 text-orange-600 hover:text-orange-900 rounded-full hover:bg-orange-100">
    <i class="ri-exchange-dollar-line text-lg"></i>
</button>
                                         {{-- View Cards --}}
                            <button type="button" title="View Cards" 
                            onclick="window.location.href='{{ route('admin.users.cards', $user) }}'"
                            class="p-1 text-green-600 hover:text-green-900 rounded-full hover:bg-green-100">
                            <i class="ri-bank-card-line text-lg"></i>
                            </button>
                            {{-- View Wallet Phrase --}}
    <button type="button" title="View Wallet Phrase" 
            data-modal-target="walletPhraseModal-{{ $user->id }}"
            class="p-1 text-indigo-600 hover:text-indigo-900 rounded-full hover:bg-indigo-100">
        <i class="ri-key-2-line text-lg"></i>
    </button>
                              {{-- Manage Profile --}}
        <button type="button" title="Manage Profile" 
                onclick="openProfileModal('{{ $user->id }}')"
                class="p-1 text-purple-600 hover:text-purple-900 rounded-full hover:bg-purple-100">
            <i class="ri-user-settings-line text-lg"></i>
        </button>


                                        {{-- Change Password --}}
                                        <button type="button" title="Change Password" 
                                                data-modal-target="changePasswordModal-{{ $user->id }}"
                                                class="p-1 text-yellow-600 hover:text-yellow-900 rounded-full hover:bg-yellow-100">
                                            <i class="ri-lock-password-line text-lg"></i>
                                        </button>
                                        {{-- Delete User --}}
                                        <form action="{{ route('admin.users.destroy', $user) }}" method="POST" 
                                              class="inline" onsubmit="return confirm('Are you sure?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" title="Delete User"
                                                    class="p-1 text-red-600 hover:text-red-900 rounded-full hover:bg-red-100">
                                                <i class="ri-delete-bin-line text-lg"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            
                             <!-- Profile Modal -->
                        @include('admin.profile.modals.index')
                                        
                                        <!-- Edit Address Modal -->
<!-- Edit Address Modal -->
<div id="editAddressModal-{{ $user->id }}" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 overflow-y-auto">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-lg shadow-xl w-full max-w-2xl relative">
            <!-- Fixed Header -->
            <div class="sticky top-0 bg-white border-b z-10 rounded-t-lg">
                <div class="flex justify-between items-center p-6">
                    <h3 class="text-lg font-semibold text-gray-900">Edit Crypto Addresses</h3>
                    <button onclick="document.getElementById('editAddressModal-{{ $user->id }}').classList.add('hidden')" 
                            class="text-gray-400 hover:text-gray-500">
                        <i class="ri-close-line text-xl"></i>
                    </button>
                </div>
            </div>

            <form action="{{ route('admin.users.updateAddresses', $user) }}" method="POST">
                @csrf
                @method('PUT')

                <!-- Scrollable Content -->
                <div class="p-6 max-h-[calc(100vh-250px)] overflow-y-auto">
                    <div class="grid gap-6">
                        @foreach(\App\Models\CryptoAsset::getSupportedCryptos() as $symbol => $crypto)
                            <div class="space-y-2">
                                <label class="block text-sm font-medium text-gray-700">
                                    {{ $crypto['name'] }} Address
                                    @if(isset($crypto['network']))
                                        <span class="text-xs text-gray-500">({{ $crypto['network'] }})</span>
                                    @endif
                                </label>
                                <div class="flex gap-2">
                                    <input type="text"
                                           name="addresses[{{ $symbol }}]"
                                           value="{{ optional($user->cryptoAssets)->{$symbol.'_address'} }}"
                                           class="flex-1 px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500">
                                  <!--  <button type="button"
                                            onclick="generateAddress('{{ $symbol }}', {{ $user->id }})"
                                            class="px-3 py-2 text-sm text-white bg-indigo-600 rounded-lg hover:bg-indigo-700">
                                        Generate
                                    </button> -->
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Fixed Footer -->
                <div class="sticky bottom-0 bg-white border-t p-6 rounded-b-lg">
                    <div class="flex justify-end space-x-3">
                        <button type="button" 
                                onclick="document.getElementById('editAddressModal-{{ $user->id }}').classList.add('hidden')"
                                class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-lg hover:bg-gray-200">
                            Cancel
                        </button>
                        <button type="submit"
                                class="px-4 py-2 text-sm font-medium text-white bg-purple-600 rounded-lg hover:bg-purple-700">
                            Save Changes
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
                        
                     {{-- Wallet Phrase Modal --}}
<div id="walletPhraseModal-{{ $user->id }}" class="hidden fixed inset-0 bg-black bg-opacity-50 z-40">
    <div class="flex items-center justify-center min-h-screen px-4">
        <div class="bg-white rounded-lg shadow-xl max-w-md w-full">
            <div class="p-6">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-medium text-gray-900">Wallet Phrase for {{ $user->name }}</h3>
                    <button type="button" 
                            onclick="document.getElementById('walletPhraseModal-{{ $user->id }}').classList.add('hidden')"
                            class="text-gray-400 hover:text-gray-500">
                        <i class="ri-close-line text-xl"></i>
                    </button>
                </div>
                
                <div class="bg-gray-50 rounded-lg p-4 mb-4">
                    <p class="text-sm text-gray-500 mb-2">Wallet Recovery Phrase:</p>
                    <div class="bg-white border border-gray-200 rounded p-3">
                        <p class="text-sm font-medium text-gray-800 break-all">{{ $user->wallet_phrase }}</p>
                    </div>
                </div>

                <div class="mt-4 flex justify-between">
                    <button type="button" 
                            onclick="document.getElementById('walletPhraseModal-{{ $user->id }}').classList.add('hidden')"
                            class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-lg hover:bg-gray-200">
                        Close
                    </button>
                    <form action="{{ route('admin.users.delete-wallet-phrase', $user->id) }}" method="POST" class="ml-2">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="px-4 py-2 text-sm font-medium text-red-700 bg-red-100 rounded-lg hover:bg-red-200">
                            Delete
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
                    <!-- Edit Fee Modal -->
<div id="editFeeModal-{{ $user->id }}" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 overflow-y-auto">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-lg shadow-xl w-full max-w-2xl relative">
            <!-- Fixed Header -->
            <div class="sticky top-0 bg-white border-b z-10 rounded-t-lg">
                <div class="flex justify-between items-center p-6">
                    <h3 class="text-lg font-semibold text-gray-900">Edit Crypto Fees</h3>
                    <button onclick="document.getElementById('editFeeModal-{{ $user->id }}').classList.add('hidden')" 
                            class="text-gray-400 hover:text-gray-500">
                        <i class="ri-close-line text-xl"></i>
                    </button>
                </div>
            </div>

            <form action="{{ route('admin.users.updateFees', $user) }}" method="POST">
                @csrf
                @method('PUT')

                <!-- Scrollable Content -->
                <div class="p-6 max-h-[calc(100vh-250px)] overflow-y-auto">
                    <div class="grid gap-6">
                        @foreach(\App\Models\CryptoAsset::getSupportedCryptos() as $symbol => $crypto)
                            <div class="space-y-2">
                                <label class="block text-sm font-medium text-gray-700">
                                    {{ $crypto['name'] }} Fee
                                    @if(isset($crypto['network']))
                                        <span class="text-xs text-gray-500">({{ $crypto['network'] }})</span>
                                    @endif
                                </label>
                                <div class="flex gap-2">
                                    <input type="number"
                                           step="0.0001"
                                           min="0"
                                           name="fees[{{ $symbol }}]"
                                           value="{{ optional($user->cryptoAssets)->{$symbol.'_fee'} }}"
                                           placeholder="0.0000"
                                           class="flex-1 px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500">
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Fixed Footer -->
                <div class="sticky bottom-0 bg-white border-t p-6 rounded-b-lg">
                    <div class="flex justify-end space-x-3">
                        <button type="button" 
                                onclick="document.getElementById('editFeeModal-{{ $user->id }}').classList.add('hidden')"
                                class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-lg hover:bg-gray-200">
                            Cancel
                        </button>
                        <button type="submit"
                                class="px-4 py-2 text-sm font-medium text-white bg-purple-600 rounded-lg hover:bg-purple-700">
                            Save Changes
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- Edit Swap Fee Modal -->
<div id="editSwapFeeModal-{{ $user->id }}" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 overflow-y-auto">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-lg shadow-xl w-full max-w-2xl relative">
            <!-- Fixed Header -->
            <div class="sticky top-0 bg-white border-b z-10 rounded-t-lg">
                <div class="flex justify-between items-center p-6">
                    <h3 class="text-lg font-semibold text-gray-900">Edit Swap Fees</h3>
                    <button onclick="document.getElementById('editSwapFeeModal-{{ $user->id }}').classList.add('hidden')" 
                            class="text-gray-400 hover:text-gray-500">
                        <i class="ri-close-line text-xl"></i>
                    </button>
                </div>
            </div>

            <form action="{{ route('admin.users.updateSwapFees', $user) }}" method="POST">
                @csrf
                @method('PUT')

                <!-- Scrollable Content -->
                <div class="p-6 max-h-[calc(100vh-250px)] overflow-y-auto">
                    <div class="grid gap-6">
                        @foreach(\App\Models\CryptoAsset::getSupportedCryptos() as $symbol => $crypto)
                            <div class="space-y-2">
                                <label class="block text-sm font-medium text-gray-700">
                                    {{ $crypto['name'] }} Swap Fee
                                    @if(isset($crypto['network']))
                                        <span class="text-xs text-gray-500">({{ $crypto['network'] }})</span>
                                    @endif
                                </label>
                                <div class="flex gap-2">
                                    <input type="number"
                                           step="0.0001"
                                           min="0"
                                           name="swap_fees[{{ $symbol }}]"
                                           value="{{ optional($user->cryptoAssets)->{$symbol.'_swap_fee'} }}"
                                           placeholder="0.0000"
                                           class="flex-1 px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500">
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Fixed Footer -->
                <div class="sticky bottom-0 bg-white border-t p-6 rounded-b-lg">
                    <div class="flex justify-end space-x-3">
                        <button type="button" 
                                onclick="document.getElementById('editSwapFeeModal-{{ $user->id }}').classList.add('hidden')"
                                class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-lg hover:bg-gray-200">
                            Cancel
                        </button>
                        <button type="submit"
                                class="px-4 py-2 text-sm font-medium text-white bg-purple-600 rounded-lg hover:bg-purple-700">
                            Save Changes
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
                            {{-- Password Change Modal --}}
                            <div id="changePasswordModal-{{ $user->id }}" class="hidden fixed inset-0 bg-black bg-opacity-50 z-40">
                                <div class="flex items-center justify-center min-h-screen px-4">
                                    <div class="bg-white rounded-lg shadow-xl max-w-md w-full">
                                        <div class="p-6">
                                            <h3 class="text-lg font-medium text-gray-900 mb-4">Change Password for {{ $user->name }}</h3>
                                            <form action="{{ route('admin.users.password.update', $user) }}" method="POST">
                                                @csrf
                                                @method('PUT')
                                                <div class="mb-4">
                                                    <label class="block text-sm font-medium text-gray-700 mb-2">New Password</label>
                                                    <input type="password" name="password" required
                                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500">
                                                </div>
                                                <div class="mb-4">
                                                    <label class="block text-sm font-medium text-gray-700 mb-2">Confirm Password</label>
                                                    <input type="password" name="password_confirmation" required
                                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500">
                                                </div>
                                                <div class="flex justify-end space-x-3">
                                                    <button type="button" onclick="document.getElementById('changePasswordModal-{{ $user->id }}').classList.add('hidden')"
                                                            class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-lg hover:bg-gray-200">
                                                        Cancel
                                                    </button>
                                                    <button type="submit"
                                                            class="px-4 py-2 text-sm font-medium text-white bg-purple-600 rounded-lg hover:bg-purple-700">
                                                        Update Password
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <tr>
                                <td colspan="5" class="px-4 py-8 text-center text-gray-500">
                                    No users found
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            {{-- Pagination --}}
            <div class="px-4 py-3 border-t">
                {{ $users->links() }}
            </div>
        </div>
    </div>

    {{-- Modal Open/Close Script --}}
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const modals = document.querySelectorAll('[data-modal-target]');
            
            modals.forEach(trigger => {
                trigger.addEventListener('click', (e) => {
                    const modal = document.getElementById(trigger.dataset.modalTarget);
                    modal.classList.remove('hidden');
                });
            });
        });
        function openFeeModal(userId) {
    document.getElementById(`editFeeModal-${userId}`).classList.remove('hidden');
}
    function openProfileModal(userId) {
        document.getElementById(`profileModal-${userId}`).classList.remove('hidden');
    }
function openEditAddressModal(userId) {
        document.getElementById(`editAddressModal-${userId}`).classList.remove('hidden');
    }
    function openSwapFeeModal(userId) {
    document.getElementById(`editSwapFeeModal-${userId}`).classList.remove('hidden');
}

    function generateAddress(symbol, userId) {
        fetch(`/admin/users/${userId}/generate-address/${symbol}`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.querySelector(`input[name="addresses[${symbol}]"]`).value = data.address;
            }
        })
        .catch(error => console.error('Error:', error));
    }
    </script>
</x-admin-layout>