<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Activity Alert</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px; }
        .container { border: 1px solid #ddd; border-radius: 5px; padding: 20px; }
        .header { background-color: #f8f9fa; padding: 10px; border-radius: 5px; margin-bottom: 20px; }
        .content { margin-bottom: 20px; }
        .footer { font-size: 12px; color: #777; margin-top: 20px; text-align: center; }
        .highlight { background-color: #f8f9fa; padding: 10px; border-radius: 3px; margin: 10px 0; }
        h1 { color: #333; font-size: 24px; margin-top: 0; }
        table { width: 100%; border-collapse: collapse; margin: 15px 0; }
        table, th, td { border: 1px solid #ddd; }
        th, td { padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>User Activity Alert</h1>
        </div>
        
        <div class="content">
            <p><strong>Activity:</strong> {{ $activity['activity'] }}</p>
            <p><strong>Description:</strong> {{ $activity['description'] }}</p>
            
            <h3>User Information</h3>
            <table>
                <tr>
                    <th>User ID</th>
                    <td>{{ $activity['user_id'] }}</td>
                </tr>
                <tr>
                    <th>Name</th>
                    <td>{{ $activity['user_name'] }}</td>
                </tr>
                <tr>
                    <th>Email</th>
                    <td>{{ $activity['user_email'] }}</td>
                </tr>
                <tr>
                    <th>Timestamp</th>
                    <td>{{ $activity['timestamp'] }}</td>
                </tr>
                <tr>
                    <th>IP Address</th>
                    <td>{{ $activity['ip_address'] }}</td>
                </tr>
                <tr>
                    <th>User Agent</th>
                    <td>{{ $activity['user_agent'] }}</td>
                </tr>
            </table>
            
            @if(!empty($activity['data']))
            <h3>Additional Details</h3>
            <div class="highlight">
                <table>
                    @foreach($activity['data'] as $key => $value)
                    <tr>
                        <th>{{ ucfirst(str_replace('_', ' ', $key)) }}</th>
                        <td>
                            @if(is_array($value))
                                <pre>{{ json_encode($value, JSON_PRETTY_PRINT) }}</pre>
                            @else
                                {{ $value }}
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </table>
            </div>
            @endif
        </div>
        
        <div class="footer">
            <p>This is an automated message. Please do not reply to this email.</p>
            <p>{{ config('app.name') }} &copy; {{ date('Y') }}</p>
        </div>
    </div>
</body>
</html> 