<nav class="md:hidden fixed bottom-4 left-4 right-4 z-40">
    <!-- Floating nav container with glass effect -->
    <div class="bg-white bg-opacity-95 backdrop-blur-md rounded-2xl shadow-[0_4px_30px_rgba(0,0,0,0.15)] border border-gray-100 overflow-hidden">
        <div class="grid grid-cols-4 gap-1">
            <a href="{{ route('dashboard') }}" 
               class="relative group flex flex-col items-center py-4 px-2 {{ request()->routeIs('dashboard') ? 'text-blue-600' : 'text-trust-text-secondary' }}">
                <div class="relative z-10 transition-all duration-300 transform group-hover:scale-110 group-hover:-translate-y-1">
                    <i class="fas fa-home text-xl"></i>
                </div>
                <span class="text-xs mt-1.5 font-medium relative z-10">Home</span>
                
                @if(request()->routeIs('dashboard'))
                <!-- Animated background effect for active item -->
                <div class="absolute bottom-0 left-0 right-0 mx-auto w-8 h-1 bg-blue-600 rounded-t-full"></div>
                <div class="absolute inset-0 bg-blue-50 opacity-50"></div>
                @endif
            </a>

            <a onclick="toggleModal('sendModal')" 
               class="relative group flex flex-col items-center py-4 px-2 cursor-pointer {{ request()->routeIs('deposit') ? 'text-blue-600' : 'text-trust-text-secondary' }}">
                <div class="relative z-10 transition-all duration-300 transform group-hover:scale-110 group-hover:-translate-y-1">
                    <i class="fas fa-download text-xl"></i>
                </div>
                <span class="text-xs mt-1.5 font-medium relative z-10">Deposit</span>
                
                @if(request()->routeIs('deposit'))
                <!-- Animated background effect for active item -->
                <div class="absolute bottom-0 left-0 right-0 mx-auto w-8 h-1 bg-blue-600 rounded-t-full"></div>
                <div class="absolute inset-0 bg-blue-50 opacity-50"></div>
                @endif
            </a>

            <a href="{{ route('swap') }}" 
               class="relative group flex flex-col items-center py-4 px-2 {{ request()->routeIs('swap') ? 'text-blue-600' : 'text-trust-text-secondary' }}">
                <div class="relative z-10 transition-all duration-300 transform group-hover:scale-110 group-hover:-translate-y-1">
                    <i class="fas fa-exchange-alt text-xl"></i>
                </div>
                <span class="text-xs mt-1.5 font-medium relative z-10">Swap</span>
                
                @if(request()->routeIs('swap'))
                <!-- Animated background effect for active item -->
                <div class="absolute bottom-0 left-0 right-0 mx-auto w-8 h-1 bg-blue-600 rounded-t-full"></div>
                <div class="absolute inset-0 bg-blue-50 opacity-50"></div>
                @endif
            </a>

            <a href="{{ route('settings') }}" 
               class="relative group flex flex-col items-center py-4 px-2 {{ request()->routeIs('settings') ? 'text-blue-600' : 'text-trust-text-secondary' }}">
                <div class="relative z-10 transition-all duration-300 transform group-hover:scale-110 group-hover:-translate-y-1">
                    <i class="fas fa-user text-xl"></i>
                </div>
                <span class="text-xs mt-1.5 font-medium relative z-10">Me</span>
                
                @if(request()->routeIs('settings'))
                <!-- Animated background effect for active item -->
                <div class="absolute bottom-0 left-0 right-0 mx-auto w-8 h-1 bg-blue-600 rounded-t-full"></div>
                <div class="absolute inset-0 bg-blue-50 opacity-50"></div>
                @endif
            </a>
        </div>
    </div>
</nav>

<style>
    /* Add minimal padding just for mobile screens */
    @media (max-width: 768px) {
        body {
            padding-bottom: 5rem !important;
        }
    }
</style>