<x-user-layout :title="'Notifications'">
    <main class="w-full mx-auto p-4 pb-24 md:pb-4 bg-white text-gray-900 transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between mb-6">
            <a href="{{ url()->previous() }}" class="text-gray-600 hover:text-gray-900">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold text-center flex-1">Notifications</h1>
            <button id="mark-all-read" class="text-sm text-blue-500 hover:text-blue-600">
                Mark All Read
            </button>
        </div>

        <!-- Notifications List -->
        <div class="space-y-3" id="notifications-container">
            @forelse($notifications as $notification)
                <div class="notification-item bg-white rounded-xl p-4 shadow-sm border border-gray-100" data-id="{{ $notification->id }}">
                    <div class="flex items-start justify-between">
                        <div class="flex items-start space-x-3">
                            <div class="mt-1 w-10 h-10 rounded-full bg-{{ $notification->is_read ? 'gray-100' : 'blue-50' }} flex items-center justify-center">
                                <i class="fas fa-bell {{ $notification->is_read ? 'text-gray-400' : 'text-blue-500' }} text-lg"></i>
                            </div>
                            <div class="flex-1">
                                <h2 class="font-medium mb-1">{{ $notification->title }}</h2>
                                <p class="text-sm text-gray-600">
                                    {{ $notification->message }}
                                </p>
                                <span class="text-xs text-gray-500 mt-1 block">
                                    {{ $notification->created_at->diffForHumans() }}
                                </span>
                            </div>
                        </div>
                        <div class="flex items-center space-x-2 ml-2">
                            @if(!$notification->is_read)
                                <button class="mark-read w-8 h-8 rounded-full bg-gray-100 flex items-center justify-center text-gray-500 hover:bg-blue-50 hover:text-blue-500" data-id="{{ $notification->id }}">
                                    <i class="fas fa-eye text-sm"></i>
                                </button>
                            @endif
                            <button class="delete-notification w-8 h-8 rounded-full bg-gray-100 flex items-center justify-center text-gray-500 hover:bg-red-50 hover:text-red-500" data-id="{{ $notification->id }}">
                                <i class="fas fa-trash text-sm"></i>
                            </button>
                        </div>
                    </div>
                </div>
            @empty
                <div class="text-center py-12 bg-white rounded-xl shadow-sm border border-gray-100">
                    <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-bell-slash text-gray-400 text-2xl"></i>
                    </div>
                    <p class="text-gray-500">No notifications yet</p>
                </div>
            @endforelse

            <!-- Pagination -->
            <div class="mt-4">
                {{ $notifications->links() }}
            </div>
        </div>
    </main>

    @push('scripts')
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Add ripple effect to notification items
        document.querySelectorAll('.notification-item').forEach(item => {
            item.addEventListener('touchstart', function(e) {
                const rect = this.getBoundingClientRect();
                const x = e.touches[0].clientX - rect.left;
                const y = e.touches[0].clientY - rect.top;
                
                const ripple = document.createElement('div');
                ripple.classList.add('ripple');
                ripple.style.left = `${x}px`;
                ripple.style.top = `${y}px`;
                
                this.appendChild(ripple);
                
                setTimeout(() => {
                    ripple.remove();
                }, 600);
            });
        });
        
        // Mark single notification as read
        document.querySelectorAll('.mark-read').forEach(button => {
            button.addEventListener('click', function() {
                const notificationId = this.getAttribute('data-id');
                
                fetch(`/notifications/${notificationId}/read`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Content-Type': 'application/json'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const notificationItem = this.closest('.notification-item');
                        notificationItem.querySelector('.fas.fa-bell').classList.remove('text-blue-500');
                        notificationItem.querySelector('.fas.fa-bell').classList.add('text-gray-400');
                        notificationItem.querySelector('.bg-blue-50').classList.add('bg-gray-100');
                        notificationItem.querySelector('.bg-blue-50').classList.remove('bg-blue-50');
                        this.remove();
                    }
                });
            });
        });

        // Delete notification
        document.querySelectorAll('.delete-notification').forEach(button => {
            button.addEventListener('click', function() {
                const notificationId = this.getAttribute('data-id');
                const notificationItem = this.closest('.notification-item');
                
                // Add fade-out animation
                notificationItem.style.transition = 'all 0.3s ease';
                notificationItem.style.opacity = '0';
                notificationItem.style.transform = 'translateX(10px)';
                
                setTimeout(() => {
                    fetch(`/notifications/${notificationId}`, {
                        method: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                            'Content-Type': 'application/json'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            notificationItem.remove();
                        }
                    });
                }, 300);
            });
        });

        // Mark all notifications as read
        document.getElementById('mark-all-read')?.addEventListener('click', function() {
            // Visual feedback with button press animation
            this.style.transform = 'scale(0.95)';
            setTimeout(() => {
                this.style.transform = 'scale(1)';
            }, 150);
            
            fetch('/notifications/mark-all-read', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.querySelectorAll('.notification-item').forEach(item => {
                        const bellIcon = item.querySelector('.fas.fa-bell');
                        if (bellIcon) {
                            bellIcon.classList.remove('text-blue-500');
                            bellIcon.classList.add('text-gray-400');
                        }
                        
                        const iconBg = item.querySelector('.bg-blue-50');
                        if (iconBg) {
                            iconBg.classList.add('bg-gray-100');
                            iconBg.classList.remove('bg-blue-50');
                        }
                        
                        const markReadBtn = item.querySelector('.mark-read');
                        if (markReadBtn) {
                            markReadBtn.remove();
                        }
                    });
                }
            });
        });
    });
    </script>
    <style>
    .ripple {
        position: absolute;
        border-radius: 50%;
        background: rgba(0, 0, 0, 0.05);
        transform: scale(0);
        animation: ripple 0.6s linear;
        pointer-events: none;
    }
    
    @keyframes ripple {
        to {
            transform: scale(4);
            opacity: 0;
        }
    }
    </style>
    @endpush
</x-user-layout>